/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin.flag.player;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_5454;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin {
    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="HEAD")}, allow=1, cancellable=true)
    private void onDropItem(class_1799 stack, boolean b1, boolean b2, CallbackInfoReturnable<class_1542> cir) {
        class_3222 player = (class_3222)this;
        if (HandlerUtil.isServerSide((class_1297)player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.ITEM_DROP, HandlerUtil.getDimKey((class_1297)player), (class_1657)player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                player.method_7270(stack);
                player.method_31548().method_5431();
                cir.setReturnValue(null);
            });
        }
    }

    @Inject(method={"changeDimension"}, at={@At(value="HEAD")}, allow=1, cancellable=true)
    private void onchangeDimension(class_5454 transition, CallbackInfoReturnable<class_1297> cir) {
        class_1657 player = (class_1657)this;
        if (HandlerUtil.isServerSide((class_1297)player)) {
            RegionDataManager.addDimKeyOnDimensionChange(player, player.method_37908(), (class_1937)transition.comp_2820());
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.USE_PORTAL_PLAYERS, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                cir.setReturnValue(null);
            });
            checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.ENTER_DIM, HandlerUtil.getDimKey((class_1937)transition.comp_2820()), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                cir.setReturnValue(null);
            });
        }
    }
}

